<?php
define('TOKEN', 'token');

session_start();

if (isset($_GET['logout'])) {
    session_unset();
    session_destroy();
}

$token = isset($_SESSION[TOKEN]) ? $_SESSION[TOKEN] : '';
if (!$token) {
    header('Location: ./login.php');
    exit();
}

include '../../Tulus.php';

$tulus = new Tulus\Tulus();

$start_date = isset($_GET['start']) ? $_GET['start'] : '';
$end_date = isset($_GET['end']) ? $_GET['end'] : '';
$is_approved = isset($_GET['is_approved']) ? '1' : '0';
$page = isset($_GET['page']) ? intval($_GET['page']) : 0;

$params = array(
    'start' => $start_date,
    'end' => $end_date,
    'is_approved' => $is_approved,
    'page' => $page,
);

if (isset($_GET['download'])) {
    $params['page'] = 0;
    $params['items'] = 5000;
}

// $query = http_build_query($params, null, '&', PHP_QUERY_RFC3986);

$report = array();
try {
    $tulus->SetAuthToken($token);
    $report = json_decode($tulus->GetPaymentReport('json', $params), true);
} catch (Tulus\LoginException $e) {
    session_unset();
    session_destroy();
    header('Location: ./login.php');
    exit();
} catch (Exception $e) {
    echo $e->getMessage();
}

// not used for now
$header = array(
    'datetime',
    'order_id',
    'buyer_email',
    'amount',
    'bank_description',
    'status',
    'extra_data',
);

// the fields to display, comment out those not wanted
$keys = array(
    'fpx_seller_txn_time',
    'fpx_seller_ex_order_no',
    'fpx_seller_order_no',
    'fpx_buyer_email',
    'agency',
    'ref_no',
    'akaun_no',
    'payment_category',
    'fpx_txn_amount',
    'fpx_buyer_bank_id',
    'fpx_buyer_bank_name',
    'fpx_debit_auth_code',
    'fpx_debit_auth_code_desc',
    'extra_data',
    'amount',
    'fpx_fpx_txn_id',
    'fpx_fpx_txn_time',
);

if (isset($_GET['download'])) {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=download.csv');
    $out = fopen('php://output', 'w');

    fputcsv($out, $header);

    foreach ($report['data'] as $row) {
        $item = array();
        foreach ($keys as $key) {
            $item[] = $row[$key];
        }
        fputcsv($out, $item);
    }

    fclose($out);
    exit();
}

// this is where the custom rules are set
function rowDisplay($key, $value)
{
    if ($key === 'fpx_seller_txn_time') {
        return substr($value, 0, -12);
    }

    return $value;
}

function pageLink($params, $page)
{
    $copy = array(
        'page' => $page,
    );

    foreach ($params as $key => $value) {
        $copy[$key] = $value;
    }

    return http_build_query($copy);
}
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Tulus Report</title>
    <link
      rel="stylesheet"
      href="https://assets.tulus.my/bootstrap-4.5/css/bootstrap.min.css"
      
      crossorigin="anonymous"
    />
  </head>
  <body class="bg-light">
    <div class="container mt-3">
      <h1 class="text-center">Tulus Report</h1>

      <div class="mt3">
        <form action="" method="get" class="form-inline">
          <div class="form-group">
            <label for="start">Start</label>
            <input type="date" name="start" class="form-control mx-sm-3" value="<?php echo $start_date ?>">
          </div>
          <div class="form-group">
            <label for="end">End</label>
            <input type="date" name="end" class="form-control mx-sm-3" value="<?php echo $end_date ?>">
          </div>
          <div class="form-check">
            <input type="checkbox" name="is_approved" class="form-check-input" id="is_approved" <?php echo $is_approved === '1' ? 'checked' : '' ?>>
            <label class="form-check-label" for="is_approved">Is Approved</label>
          </div>
          <button type="submit" class="btn btn-primary ml-2">Update</button>
          <button type="submit" class="btn btn-info ml-1" name="download">Download</button>
        </form>
      </div>

      <?php if (!empty($report['stats'])): ?>
      <nav aria-label="report pagination" class="my-3">
        <form action="" method="get">
          <span>Page: </span>
          <input type="hidden" name="start" value="<?php echo $start_date ?>">
          <input type="hidden" name="end" value="<?php echo $end_date ?>">
          <input type="hidden" name="is_approved" <?php echo $is_approved === '1' ? 'checked' : '' ?>>
          <select name="page" class="custom-select ml-1" style="max-width: 100px">
            <?php for ($i = 0; $i < $report['stats']['total_pages']; $i++): ?>
              <option
                value="<?php echo $i ?>"
                <?php echo ($i === $page) ? 'selected' : '' ?>
              >
                <?php echo $i + 1 ?>
              </option>
            <?php endfor?>
          </select>

          <button type="submit" class="btn btn-primary ml-1">Go</button>
        </form>
      </nav>
      <?php endif?>

      <?php if (!empty($report['data'])): ?>
      <div class="table-responsive-sm">
        <table class="table table-striped table-hover">
          <caption></caption>
          <thead class="thead-dark">
            <tr>
            <?php foreach ($keys as $key): ?>
              <th scope="col"><?php echo $key ?></th>
            <?php endforeach?>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($report['data'] as $row): ?>
            <tr>
              <?php foreach ($keys as $key): ?>
              <td><?php echo $row[$key] ?></td>
              <?php endforeach?>
            </tr>
            <?php endforeach?>
          </tbody>
        </table>
      </div>
      <?php endif?>

    </div>
  </body>
</html>
