<?php

// Example of reconciliation, designed to run on command line.
// You can refer to report/index.php for an example of a web based
// custom report

include '../../Tulus.php';

$tulus = new Tulus\Tulus();

// Get this token by logging into https://reports.tulus.my/
// and clicking on the username on top right, and clicking "Copy AuthToken to Clipboard"
// It is a very long JWT string.
$token = "PLACEHOLDER";
// Set this to your agency
$agency = "tulus";

if (file_exists("config.inc.php")) {
    // The contents of this file should just set
    // $token and $agency, and not be checked into source control.
    require_once "config.inc.php";
}
$tulus->SetAuthToken($token);

// There's two ways to check for updates, iterating through all approved payments
// here every day (Method A), or cherry pick certain transactions (Method B)

$method = 'A';

if ($method == 'A') {
    // Customize to date you're interested in.
    // By default, we grab yesterday and today's data:
    $end_date = date('Y-m-d'); // today's date
    $start_date = date('Y-m-d', strtotime("-1 days")); // yesterday
    
    $is_approved = '0'; // Set to '1' if we just want to check for those that's been approved

    // Instead of accidentally grabbing too much data and overwhelm our workstation,
    // we process things page by page.
    $page = 0;


    do {
        $params = array(
            'start' => $start_date,
            'end' => $end_date,
            'is_approved' => $is_approved,
            'page' => $page,
            'items' => 5000, // 5000 items at one go, maximum
        );
        $report = json_decode($tulus->GetPaymentReport('json', $params), true);

        for ($i = 0; $i < sizeof($report['data']); $i++) {
            $record = $report['data'][$i];

            if ($record['fpx_debit_auth_code'] == '00') {
                print "Transaction approved\n";

                // This is the ref no we passed.
                print "Ref No: ". $record["ref_no"]. "\n"; 

                // This is the transaction order no MEPS use as primary key
                print "FPX Seller Order No: ".$record['fpx_seller_order_no']."\n";

                print "Amount: ".$record['fpx_txn_amount']."\n";

                print "FPX Buyer Email: ". $record['fpx_buyer_email']."\n";

                // print_r($record); // Other verbose details
                print "\n";

                if (true) {
                    // This is where you'd update your system to mark this
                    // transaction as approved, and deduct anything as neccessary.

                    // Do check if this is already processed to avoid double deduction.
                }
            } else {
                // Not approved
                // print "Not approved";
            }
        }

        if (isset($report["stats"]["total_pages"])) {
            if ($page < $report["stats"]["total_pages"]) {
                $page++;
                continue;
            }
        }
    } while (false);
} else if ($method == 'B') {
    // If we have already done the above, and we have a list of
    // fpx_seller_order_no that's not complete, we can specifically
    // check them again:
    $fpx_seller_order_nos = array(
        'test3333e4e477c01',
        'test516555537c031',
    );
    $is_approved = '0'; // Set to '1' if we just want to check for those that's been approved

    // Instead of accidentally grabbing too much data and overwhelm our workstation,
    // we process things page by page.
    $page = 0;

    foreach ($fpx_seller_order_nos as $k => $seller_order_no) {
        $params = array(
            'is_approved' => $is_approved,
            'page' => $page,
            'seller_order_no' => $seller_order_no,
            'items' => 1,
        );
        $report = json_decode($tulus->GetPaymentReport('json', $params), true);
        for ($i = 0; $i < sizeof($report['data']); $i++) {
            $record = $report['data'][$i];

            if ($record['fpx_debit_auth_code'] == '00') {
                print "Transaction approved\n";

                // This is the ref no we passed.
                print "Ref No: ". $record["ref_no"]. "\n"; 

                // This is the transaction order no MEPS use as primary key
                print "FPX Seller Order No: ".$record['fpx_seller_order_no']."\n";

                print "Amount: ".$record['fpx_txn_amount']."\n";

                print "FPX Buyer Email: ". $record['fpx_buyer_email']."\n";

                // print_r($record); // Other verbose details
                print "\n";

                if (true) {
                    // This is where you'd update your system to mark this
                    // transaction as approved, and deduct anything as neccessary.

                    // Do check if this is already processed to avoid double deduction.
                }
            } else {
                // Not approved
                // print "Not approved";
            }
        }
    }
}
