<?php

// Use:
//   php -S localhost:8000
// To quickly test

// Requires curl
// Tulus.php uses newer AuthToken which is not the same as "token" used here.
include 'SnapNPay.php';

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';
$savedToken = $_GET['token'] ?? "90069AAB1234";
$agency = $_POST['agency'] ?? $_GET['agency'] ?? "";

$snp = new SnapNPay\SnapNPay($agency, $savedToken);
$snp->SetToken($savedToken);
$fpx_refno = $_POST['refno'] ?? '';

// $snp->SetEndpoint("http://localhost:28080");

// ----------------------------------------------------------------------------------------------------------------
function isSecure()
{
    return
        (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
        || $_SERVER['SERVER_PORT'] == 443;
}

$scheme = isSecure() ? 'https' : 'http';

// ----------------------------------------------------------------------------------------------------------------
// Payment API Example
// This is vastly simplified. Use and adapt for your own class
// Unless otherwise stated, the types in the following fields are specified in string, and is up to 255 bytes ASCII
// Use of UTF-8 values in the following may result in undefined behaviours.
$scheme = isSecure() ? 'https' : 'http';
$returnUrl = sprintf("%s://%s", $scheme, $_SERVER['HTTP_HOST']);
$order = array(
    'agency' => 'snapnpay', // Enter your agency code here.
    'refno' => uniqid("test"), // Generate a unique ID, prefixed with "test", but append some "extraData"
    'amount' => "1.00", // Amount in Ringgit

    // Email skipped for qrcode. Person who scans, will enter it.
    // 'email' => "sdk@snapnpay.my", // Email address of payer to receive payment receipt
    'returnUrl' => $returnUrl, // callback url, change this to your form

    // extraData is extra, *optional* reference for helping the calling app, e.g. adding a MyKad reference.
    // it can be anything alphanum, except "~"
    'extradata' => "881225-08-1234",

    'extrafragment' => "",
);

// Load $order from $_POST
if (isset($_POST['agency'])) {
    $order['agency'] = strtoupper($_POST['agency']);
}
if (isset($_POST['extradata'])) {
    $order['extradata'] = strtoupper($_POST['extradata']);
}
if (isset($_POST['amount'])) {
    if ($_POST['amount'] == "") {
        $order['amount'] = "";    
    } else {
        $order['amount'] = sprintf("%.2f", floatval($_POST['amount']));
    }
}
if (($order['$extradata']??"") != "") {
    // We hitch on refno to give this extradata
    $order['refno'] = $order['refno'] . "~" . $order['$extradata'];
}

// Default QR Code Generator for the SnapNPay App
// This is simplified structure of the QRCode generator. Use and adapt for your own class.
// We'll generate a QRCode for the above $order:
$qrcode = array(
    'agency' => $order['agency'],
    'paymentCategory' => 'test',
    'refno' => $order['refno'],
    'extradata' => '',
);
// Email skipped for qrcode. Person who scans, will enter it.

$errors = array();
if (sizeof($_POST) > 0 && $_POST['qrcode']) {
    // Validate and correct
    $qrcode['agency'] = strtoupper($_POST['qrcode']);

    $extraData = $_POST['extradata'];
    $refno = $_POST['refno'];
    if (strpos($refno, "~") !== false) {
        $errors[] = "You cannot have ~ in your refno";
    }
    if ($extraData != "") {
        $qrcode['refnoFull'] = $refno . "~" . $extraData;
    } else {
        $qrcode['refnoFull'] = $refno;
    }
    $qrcode['refno'] = $_POST['refno'];

    $errors = $snp->validateExtraData($_POST['extradata']);
    if (sizeof($errors) == 0) {
        $qrcode['extradata'] = $_POST['extradata'];
    }
}

// Note the similarity of the qrcode structure with $order above, but:
// "email" is not used -- they will be filled in by the SnapNPay App
// "returnUrl" is optional

// There are two types of QRCode generation, secure ("signed/tamper resistant") and unsigned.
// You need to sign in (and get the secure token), to be able to generate the secured QR Code.
if (false) {
    // Example:
    $token = $snp->GetToken("myagency", "mypassword");
    for ($i = 0; $i < 10; $i++) {
        $qrcode['refno'] = uniqid($i);
        $snp->GetSecureQRCodeUrl($qrcode); // Returns a URL that will return a PNG of the QR Code.
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <meta http-equiv="X-UA-Compatible" content="ie=edge" />
  <title>SnapNPay API &amp; QRCode Playground</title>
  <link rel="icon" type="image/png" href="https://assets.tulus.my/tulus-icon.png" sizes="32x32" />

  <link rel="stylesheet" href="https://assets.tulus.my/bootstrap-4.5/css/bootstrap.min.css"
    crossorigin="anonymous">
  <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"
    integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj"
    crossorigin="anonymous"></script>
  <script src="https://assets.tulus.my/popperjs/popper.js" ></script>
  <script src="https://assets.tulus.my/bootstrap-4.5/js/bootstrap.min.js"
    
    crossorigin="anonymous"></script>
  <script>
    function isValidEmail(email) {
      var regex = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
      return email.match(regex);
    }
    function checkValidEmail(email) {
      if (!isValidEmail(email)) {
        alert("Please enter a valid email");
      }
    }
  </script>
</head>

<body>
  <div class="d-flex flex-column flex-md-row align-items-center p-3 px-md-4 mb-3 bg-white border-bottom box-shadow">
    <h5 class="my-0 mr-md-auto font-weight-normal">SnapNPay API - QRCode Playground</h5>
  </div>
  <div class="container p-0">

    <?php
if (sizeof($_POST) > 0 && $_POST['qrcode']) {
    $qrcode['agency'] = $_POST['agency'];
    $qrcode['paymentCategory'] = $_POST['paymentCategory'];
    $qrcode['refno'] = $_POST['refno'];
    $qrcode['amount'] = $_POST['amount'];

    if (isset($_POST['refnounique'])) {
        $qrcode['refnounique'] = $_POST['refnounique'];
    }

    $extra_keys = $_POST['extra_keys'] ?? [];
    $extra_values = $_POST['extra_values'] ?? [];

    $extra_data = array();
    if ($extra_keys != "") {
        for ($i = 0; $i < count($extra_keys); $i++) {
            if ($extra_keys[$i] !== '') {
                $key = $extra_keys[$i];
                $value = $extra_values[$i];
                $extra_data[$key] = $value;
            }
        }
    }

    if (count($extra_data) > 0) {
        $qrcode['extras'] = $extra_data;
    }

    // $qrcode['amount'] = sprintf("%.2f", $qrcode['amount']);

    $qrcode['extrafragment'] = $_POST['extrafragment'] ?? "";
}
?>
    <div style="border: 2px solid; padding: 0.5em" class="container">
      <h5 class="p-0">Secure QR Code Generation</h5>
      <form action="qrcode.php" method="POST">
        <input type="hidden" name="qrcode" value="1" />

        <div class="form-group p-0 m-0 row">
          <label for="token" class="col-sm-2 col-form-label"><b>Security Token</b>:<br /><code>token</code>
            (Required)</label>
          <div class="col-sm-4">
            <input name="token" value="<?php print($savedToken);?>" type="text" class="form-control" id="token"
              aria-describedby="tokenHelp" />
          </div>
          <div class="col-sm-6">
            <small id="tokenHelp" class="form-text text-muted">
              Security Token given by SnapNPay.<br />
              Used by SnapNPay to verify and sign the QRCode.<br />
              Use "90069AAB1234" as a universal development token.
            </small>
          </div>
        </div>

        <div class="form-group p-0 m-0 row">
          <label for="agency" class="col-sm-2 col-form-label"><b>Agency</b>: <br /><code>agency</code>
            (Required)</label>
          <div class="col-sm-4">
            <input name="agency" value="<?php print $qrcode['agency']?>"" type=" text" class="form-control" id="agency"
              aria-describedby="agencyHelp" />
          </div>
          <div class="col-sm-6">
            <small id="agencyHelp" class="form-text text-muted">Agency Code. Also known as Merchant ID.<br />
              AlphaNumeric, with dashes. For example "snapnpay".
            </small>
          </div>
        </div>

        <div class="form-group p-0 m-0 row">
          <label for="paymentCategory" class="col-sm-2 col-form-label"><b>Payment
              Category</b>:<br /><code>paymentCategory</code> (Required)</label>
          <div class="col-sm-4">
            <input name="paymentCategory" value="<?php print $qrcode['paymentCategory']?>"" type=" text"
              class="form-control" id="paymentCategory" aria-describedby="paymentCategoryHelp" />
          </div>
          <div class="col-sm-6">
            <small id="paymentCategoryHelp" class="form-text text-muted">
              Category of payment, for reporting.
              <br />AlphaNumeric, no spaces. For example "compound".
            </small>
          </div>
        </div>

        <div class="form-group p-0 m-0 row">
          <label class="col-sm-2 form-check-label" for="refNounique">
            <b>Order is Unique?</b>
          </label>
          <div class="col-sm-4">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" name="refnounique"
                <?php print ($qrcode['refnounique']??"") ? "checked='1'" : "";?>" id="refNounique" aria-describedby="uniqueHelp" />
              <label class=" form-check-label" for="refNounique">
                Order is Unique
              </label>
            </div>
          </div>
          <div class="col-sm-6">
            <small id="uniqueHelp" class="form-text text-muted">
              Is this Order unique (one-of) or is this orderable and payable multiple times?
              <br />
            </small>
          </div>
        </div>

        <div class="form-group p-0 m-0 row">
          <label for="refno" class="col-sm-2 col-form-label"><b>Reference Number</b>:<br /><code>refno</code>
            (Required)</label>
          <div class="col-sm-4">
            <input name="refno" value="<?php print urlencode($qrcode['refno'])?>"" type=" text" class="form-control"
              id="refno" aria-describedby="refnoHelp" />
          </div>
          <div class="col-sm-6">
            <small id="refnoHelp" class="form-text text-muted">
              Reference number for this payment. Each payment must be unique for each agency.
              <br />
            </small>
          </div>
        </div>

        <div class="form-group p-0 m-0 row">
          <label for="amount" class="col-sm-2 col-form-label"><b>Amount</b>:<br /><code>amount</code></label>
          <div class="col-sm-4">
            <input name="amount" value="<?php print $qrcode['amount']??"" ?>"" type=" text" class="form-control" id="amount"
              aria-describedby="amountHelp" />
          </div>
          <div class="col-sm-6">
            <small id="amountHelp" class="form-text text-muted">
              Amount, in Ringgit Malaysia
              <br />Numeric, no commas.
            </small>
          </div>
        </div>

        <div class="form-group p-0 m-0 row">
          <label for="amount" class="col-sm-2 col-form-label"><b>ExtraData</b>:<br /><code>extradata</code></label>
          <div class="col-sm-4">
            <input name="extradata" value="<?php print($qrcode['extradata']??"");?>"" type=" text" class="form-control"
              id="extradata" aria-describedby="extradataHelp" />
          </div>
          <div class="col-sm-6">
            <small id="extradataHelp" class="form-text text-muted">
              Extra Data
              <br />AlphaNumeric, no tilde (~)
            </small>
          </div>
        </div>

        <div class="form-group p-0 m-0 row">
          <label for="amount" class="col-sm-2 col-form-label"><b>ExtraFragment</b>:<br /><code>extrafragment</code></label>
          <div class="col-sm-4">
            <input name="extrafragment" value="<?php print($qrcode['extrafragment']??"");?>"" type=" text" class="form-control"
              id="extrafragment" aria-describedby="extrafragmentHelp" />
          </div>
          <div class="col-sm-6">
            <small id="extrafragmentHelp" class="form-text text-muted">
              Extra Fragment
              <br />AlphaNumeric.
            </small>
          </div>
        </div>

        <div class="form-group p-0 m-0 row">
          <div class="col-sm-2"></div>
          <div class="col-sm-10">
            <button class="btn btn-primary" type="submit">Generate QR Code</button>
          </div>
        </div>
      </form>
    </div>

    <?php
if (sizeof($_POST) > 0 && $_POST['qrcode']) {
    $errors = $snp->ValidateQRCode($qrcode);

    if (sizeof($errors) > 0) {
        foreach ($errors as $k => $e) {
            print "<code>" . $e . "</code><br />";
        }
    } else {
        $img = $snp->GetQRCodeUrl($qrcode);
        // https://snapnpay.my/pay/WK-20040#name=Perbadanan%20Wakaf%20Selangor%20(Petron%20Klang%20Prade%20Jalan%20Meru)
        
        // name=Perbadanan Wakaf Selangor (Petron Klang Prade Jalan Meru)
        // name=Perbadanan%20Wakaf%20Selangor%20(Petron%20Klang%20Prade%20Jalan%20Meru)

        if ($img === false) {
            print "Can't get QR Code";
        } else {
            // Unwrap img.
            $parsed = parse_url($img);
            $parsed_q = array();
            parse_str($parsed['query'], $parsed_q);
            $qrcode_content = $parsed_q['q'];

            print "<h5>Plain QR Code representing the above:</h5>";
            print "The QR Code decodes as: <br /><code>" . $qrcode_content . "</code><br />";
            print "To generate the QR Code Image:<br /> <code>" . $img . "</code><br />";
            print '<img src="' . $img . '"/>';
            print "<br />";
        }

        $img = $snp->GetSecureQRCodeUrl($qrcode);
        if ($img === false) {
            print "Can't get Secure QR Code";
        } else {
            // Unwrap img.
            $parsed = parse_url($img);
            $parsed_q = array();
            parse_str($parsed['query'], $parsed_q);
            $qrcode_content = $parsed_q['q'];

            print "Secure QR Code:<br />";

            print "QR Code Image: <code>" . $img . "</code><br />";
            //

            print "QR Code Content: <code>" . $qrcode_content . "</code><br />";

            $split = explode("/", $qrcode_content);
            // print_r($split);

            // Emulate Mobile
            $split2 = explode("?", $split[7]);
            $params = array(
                'refno' => $split[6],
                'agency' => $split[4],
                'paymentCategory' => $split[5],
                'amount' => $split2[0],
                'email' => 'dev@snapnpay.my',
            );
            $fragment = "https://prod.snapnpay.co/payments/mobile/checkout/" . $params['refno'] . '/' . $params['amount'] . '/' . $params['agency'] . '/' . $params['email'];
            print "Checkout URL: <code>" . $fragment . "</code><br />";

            print '<div class="row justify-content-center" style="height: 256px; width: 256px; margin:auto">';
            print '<img id="qrcode" src="' . $img . '"';
            print ' style="height: 256px; width: 256px; position: absolute; margin: auto" />';
            print '<img src="https://assets.snapnpay.my/images/' . strtoupper($params['agency']) . '.jpg" ';
            print ' style="min-height: 32px; max-height: 60px; width: 60px; position: absolute; margin-top: 96px" />';
            print '</div>';
            // print '<img src="' . $img . '"/>';
        }
        print "<hr />";


        $img = $snp->GetQRCodeUrl($qrcode);

        if ($img === false) {
            print "Can't get QR Code";
        } else {
            // Unwrap img.
            $parsed = parse_url($img);
            $parsed_q = array();
            parse_str($parsed['query'], $parsed_q);
            $qrcode_content = $parsed_q['q'];

            print "<h5>Plain QR Code representing the above:</h5>";
            print "The QR Code decodes as: <br /><code>" . $qrcode_content . "</code><br />";
            print "To generate the QR Code Image:<br /> <code>" . $img . "</code><br />";
            
            // print '<img src="' . $img . '"/>';

            print '<div class="row justify-content-center" style="height: 256px; width: 256px; margin:auto">';
            print '<img id="qrcode" src="' . $img . '"';
            print ' style="height: 256px; width: 256px; position: absolute; margin: auto" />';
            print '<img src="https://assets.snapnpay.my/images/' . strtoupper($qrcode['agency']) . '.jpg" ';
            print ' style="min-height: 32px; max-height: 60px; width: 60px; position: absolute; margin-top: 96px" />';
            print '</div>';

            print "<br />";
        }

        if (method_exists($snp, "GetDuitNowQRCodeUrl")) {
            $img = $snp->GetDuitNowQRCodeUrl($qrcode);
        } else {
            $img = false;
        }
        if ($img === false) {
            print "Can't get DuitNow QR Code";
        } else {
            // Unwrap img.
            $parsed = parse_url($img);
            $parsed_q = array();
            parse_str($parsed['query'], $parsed_q);
            $qrcode_content = $parsed_q['q'];

            print "DuitNow QR Code:<br />";

            print "QR Code Image: <code>" . $img . "</code><br />";
            //

            print "QR Code Content: <code>" . $qrcode_content . "</code><br />";

            $split = explode("/", $qrcode_content);
            // print_r($split);

            // Emulate Mobile
            // $split2 = explode("?", $split[7]);
            // $params = array(
            //     'refno' => $split[6],
            //     'agency' => $split[4],
            //     'paymentCategory' => $split[5],
            //     'amount' => $split2[0],
            //     'email' => 'dev@snapnpay.my',
            // );
            // $fragment = "https://prod.snapnpay.co/payments/mobile/checkout/" . $params['refno'] . '/' . $params['amount'] . '/' . $params['agency'] . '/' . $params['email'];
            // print "Checkout URL: <code>" . $fragment . "</code><br />";

            print '<div class="row justify-content-center" style="height: 256px; width: 256px; margin:auto">';
            print '<img id="qrcode" src="' . $img . '"';
            print ' style="height: 256px; width: 256px; position: absolute; margin: auto" />';
            print '<img src="https://assets.snapnpay.my/images/duitnow.png" ';
            print ' style="min-height: 32px; max-height: 60px; width: 60px; position: absolute; margin-top: 96px" />';
            print '</div>';
            // print '<img src="' . $img . '"/>';
        }
        print "<hr />";
    }
}
?>
    <pre><?php if ($output??"") {echo htmlspecialchars(json_encode(json_decode($output), JSON_PRETTY_PRINT));}
;?></pre>

    <?php
// Purely for debugging
if (true) {
    if (sizeof($_POST) > 0 || sizeof($_GET) > 0) {
        print "<h3>Responses</h3>";
        print "<div style='border: 2px black solid'><div style='padding: 1em'>";
        print "POST variables: <pre>";
        print_r($_POST);
        print "</pre><br />";
        print "GET variables: <pre>";
        print_r($_GET);
        print "</pre><br />";
        print "</div></div>";
    }
}
?>
  </div>

</body>

</html>