<?php

class woocommerce
{
    public $endpoint;
    private $userpass;
    private $debug;

    public function __construct($endpoint, $user, $pass)
    {
        $this->userpass = $user . ":" . $pass;
        $this->endpoint = $endpoint;
        $this->debug = false;
    }

    public function setDebug($d)
    {
        settype($d, "boolean");
        $this->debug = $d;
    }

    public function listCustomers($role)
    {
        $url = "/wp-json/wc/v3/customers";
        if (empty($role)) {
            $role = 'all';
        }

        $page = 1;
        $customers = array();

        for ($page = 1;; $page++) {
            $q = array(
                'role' => $role,
                'page' => $page,
                'per_page' => 20,
            );
            $query = "?" . http_build_query($q);

            $fullurl = $this->endpoint . $url . $query;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_URL, $fullurl);
            // curl_setopt($ch, CURLOPT_POST, true);
            // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            // curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
            curl_setopt($ch, CURLOPT_USERPWD, $this->userpass);
            $resp = curl_exec($ch);
            $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            $customerspage = json_decode($resp, true);
            if (!is_array($customerspage)) {
                break;
            }
            $customers = array_merge($customers, $customerspage);
            if (sizeof($customerspage) < 20) {
                break;
            }
        }

        return $customers;
    }

    public function listProducts($params = array())
    {
        $url = "/wp-json/wc/v3/products";

        $page = 1;
        $products = array();

        for ($page = 1;; $page++) {
            $q = array(
                'page' => $page,
                'per_page' => 20,
            );

            if (is_array($params)) {
                if (isset($params['category'])) {
                    $q['category'] = $params['category'];
                }
            }

            $query = "?" . http_build_query($q);

            $fullurl = $this->endpoint . $url . $query;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_URL, $fullurl);
            curl_setopt($ch, CURLOPT_USERPWD, $this->userpass);
            $resp = curl_exec($ch);
            if ($this->debug) {
                print("full url is " . $fullurl . "\n");
                print("userpass is " . $this->userpass . "\n");
            }
            $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            $productspage = json_decode($resp, true);
            if (!is_array($productspage)) {
                print "not array $fullurl";
                print "statusCode $statusCode resp $resp";
                break;
            }
            $products = array_merge($products, $productspage);
            if (sizeof($productspage) < 20) {
                break;
            }
        }

        return $products;
    }

    public function getOrder($id)
    {
        $url = "/wp-json/wc/v3/orders/$id";
        $target = $this->endpoint . $url;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_URL, $target);
        curl_setopt($ch, CURLOPT_USERPWD, $this->userpass);
        $resp = curl_exec($ch);
        if ($this->debug) {
            print("full url is " . $target . "\n");
            print("userpass is " . $this->userpass . "\n");
        }

        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($statusCode !== 200) {
            throw new Exception('failed to get order');
        }

        $order = json_decode($resp, true);
        return $order;
    }

    public function listOrdersPaged($params = array())
    {
        $url = "/wp-json/wc/v3/orders";

        if (!isset($params['page'])) {
            $params['page'] = '1';
        }

        if (!isset($params['per_page'])) {
            $params['per_page'] = '100';
        }

        if (!isset($params['orderby'])) {
            $params['orderby'] = 'date';
        }

        $query = http_build_query($params);
        $target = $this->endpoint . $url . '?' . $query;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_URL, $target);
        curl_setopt($ch, CURLOPT_USERPWD, $this->userpass);
        $resp = curl_exec($ch);

        return json_decode($resp, true);
    }

    public function listOrders($params = array())
    {
        $url = "/wp-json/wc/v3/orders";

        $page = 1;
        $orders = array();

        for ($page = 1;; $page++) {
            $q = array(
                'page' => $page,
                'per_page' => 20,
            );

            if (is_array($params)) {
                if (isset($params['category'])) {
                    $q['category'] = $params['category'];
                }
            }

            $query = "?" . http_build_query($q);

            $fullurl = $this->endpoint . $url . $query;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_URL, $fullurl);
            curl_setopt($ch, CURLOPT_USERPWD, $this->userpass);
            $resp = curl_exec($ch);
            if ($this->debug) {
                print("full url is " . $fullurl . "\n");
                print("userpass is " . $this->userpass . "\n");
            }
            $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            $orderspage = json_decode($resp, true);
            if (!is_array($orderspage)) {
                print "not array $fullurl";
                print "statusCode $statusCode resp $resp";
                break;
            }
            $orders = array_merge($orders, $orderspage);
            if (sizeof($orderspage) < 20) {
                break;
            }
        }

        return $orders;
    }

    public function updateProduct($id, $data)
    {
        if (empty($id)) {
            return;
        }
        $url = "/wp-json/wc/v3/products";
        $data_json = json_encode($data);

        $fullurl = $this->endpoint . $url . "/" . $id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_URL, $fullurl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
        curl_setopt($ch, CURLOPT_USERPWD, $this->userpass);
        $resp = curl_exec($ch);
        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        $product = json_decode($resp, true);
        return $product;
    }

    public function updateStatus($id, $data)
    {
        if (empty($id)) {
            return;
        }
        $url = "/wp-json/wc/v3/orders";
        $data_json = json_encode($data);

        $fullurl = $this->endpoint . $url . "/" . $id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_URL, $fullurl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
        curl_setopt($ch, CURLOPT_USERPWD, $this->userpass);
        $resp = curl_exec($ch);
        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        $order = json_decode($resp, true);
        return $order;
    }

    public function listCategories()
    {
        $url = "/wp-json/wc/v3/products/categories";

        $page = 1;
        $categories = array();

        for ($page = 1;; $page++) {
            $q = array(
                'page' => $page,
                'per_page' => 20,
            );

            $query = "?" . http_build_query($q);

            $fullurl = $this->endpoint . $url . $query;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_URL, $fullurl);
            curl_setopt($ch, CURLOPT_USERPWD, $this->userpass);
            $resp = curl_exec($ch);
            if ($this->debug) {
                print("full url is " . $fullurl . "\n");
                print("userpass is " . $this->userpass . "\n");
            }
            $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            $categoriespage = json_decode($resp, true);
            if (!is_array($categoriespage)) {
                // print "not array $fullurl";
                // print "statusCode $statusCode resp $resp";
                break;
            }
            $categories = array_merge($categories, $categoriespage);
            if (sizeof($categories) < 20) {
                break;
            }
        }

        return $categories;
    }
}

// Helper functions to convert raw woocommerce data into easier to program structures.
class wchelper
{
    /*
    categories converts wc categories into: category['slug'] => $category['id']
    Array(
    [accessories] => 16
    [hoodies] => 17
    [swcorp] => 19
    [tshirts] => 18
    [uncategorized] => 15
    );
     */
    public static function categories($wc_categories)
    {
        $a = array();
        foreach ($wc_categories as $k => $v) {
            $a[$v['slug']] = $v['id'];
        }
        return $a;
    }
}
